/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.property.VWBaseStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWStepAssignmentPanel;
import filenet.vw.toolkit.runtime.property.VWStepAttachmentsPanel;
import filenet.vw.toolkit.runtime.property.VWStepFieldsPanel;
import filenet.vw.toolkit.runtime.property.VWStepGeneralPanel;
import filenet.vw.toolkit.runtime.property.VWStepParameterPanel;
import filenet.vw.toolkit.runtime.property.VWStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWStepRoutingPanel;
import filenet.vw.toolkit.runtime.property.VWStepRulePanel;
import filenet.vw.toolkit.runtime.property.VWStepWFGroupsPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.runtime.table.VWStepNParticipantRenderer;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;

public class VWQueueUserStepPropPanel
extends VWBaseStepPropPanel
implements ChangeListener,
ItemSelectable,
ItemListener,
IVWPropertyChangeListener {
    private Vector m_participants = null;
    private JPanel m_topPanel;
    private JPanel m_queuePanel;
    private VWStepGeneralPanel m_generalPanel;
    private VWStepFieldsPanel m_fieldsPanel;
    private VWStepAttachmentsPanel m_attachmentsPanel;
    private VWStepAssignmentPanel m_assignmentsPanel;
    private VWStepParameterPanel m_parameterPanel;
    private VWStepWFGroupsPanel m_wfGroupsPanel;
    private VWStepRoutingPanel m_routingPanel;
    private int m_lockStatus = 1;
    private boolean m_bDirty = false;
    private VWStepNParticipantRenderer m_stepAndParticipantRenderer;
    private JLabel m_queueNameLabel;
    private JTextField m_queueNameUI;
    private JPanel m_viewByPanel;
    private JRadioButton m_stepRadio;
    private JRadioButton m_participantRadio;
    private JComboBox m_participantCombo;
    private DefaultComboBoxModel m_participantsModel;
    private ItemListener m_participantComboItemListener;
    private ItemListener m_stepRadioItemListener;
    private ItemListener m_participantRadioItemListener;

    public VWQueueUserStepPropPanel(VWStepPropPanel stepPropPanel, Frame parentFrame) {
        super(stepPropPanel, parentFrame);
    }

    protected void createTabs() {
        this.m_generalPanel = new VWStepGeneralPanel(this.m_parentFrame, this);
        this.updatePanelsComponentOrientation(this.m_generalPanel);
        this.m_fieldsPanel = new VWStepFieldsPanel(this.m_parentFrame, this);
        this.updatePanelsComponentOrientation(this.m_fieldsPanel);
        this.m_attachmentsPanel = new VWStepAttachmentsPanel(this.m_parentFrame, this);
        this.updatePanelsComponentOrientation(this.m_attachmentsPanel);
        this.m_wfGroupsPanel = new VWStepWFGroupsPanel(this.m_parentFrame, this);
        this.updatePanelsComponentOrientation(this.m_wfGroupsPanel);
        this.m_parameterPanel = new VWStepParameterPanel(this.m_parentFrame, this);
        this.updatePanelsComponentOrientation(this.m_parameterPanel);
        this.m_assignmentsPanel = new VWStepAssignmentPanel(this.m_parentFrame, this);
        this.updatePanelsComponentOrientation(this.m_assignmentsPanel);
        this.m_routingPanel = new VWStepRoutingPanel(this.m_parentFrame, this);
        this.updatePanelsComponentOrientation(this.m_routingPanel);
        if (this.getAreRulesEnabled()) {
            this.m_rulesPanel = new VWStepRulePanel(this.m_parentFrame, this);
            this.updatePanelsComponentOrientation(this.m_rulesPanel);
        }
        this.m_tabs = new Vector();
        this.m_tabs.add(this.m_generalPanel);
        this.m_tabs.add(this.m_fieldsPanel);
        this.m_tabs.add(this.m_attachmentsPanel);
        this.m_tabs.add(this.m_wfGroupsPanel);
        this.m_tabs.add(this.m_parameterPanel);
        this.m_tabs.add(this.m_assignmentsPanel);
        this.m_tabs.add(this.m_routingPanel);
        if (this.m_rulesPanel != null) {
            this.m_tabs.add(this.m_rulesPanel);
        }
    }

    public void initialize() {
        if (this.isTrackerDataInitialized()) {
            this.initViewByPanel();
            VWPropertyChangeNotifier.addPropertyChangeListener(this);
        }
        if (this.isTrackerDataInitialized()) {
            this.setSelectionChanged(4);
            this.initData();
            this.updateSelectedTabNow();
        }
    }

    private void setupTopPanel() {
        if (this.m_bLayoutInitialized) {
            return;
        }
        this.m_topPanel = new JPanel();
        this.setupQueuePanel();
        this.setupInstructionBorder(VWResource.s_instructions);
        this.m_topPanel.setLayout(new BorderLayout());
        this.m_topPanel.add((Component)this.m_queuePanel, "First");
        this.m_topPanel.add((Component)this.m_instructionBorder, "Center");
    }

    private void setupQueuePanel() {
        GridBagConstraints c = new GridBagConstraints();
        this.m_queuePanel = new JPanel();
        this.m_queuePanel.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 6);
        c.fill = 2;
        c.weightx = 0.0;
        this.m_queueNameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_queue));
        this.m_queuePanel.add((Component)this.m_queueNameLabel, c);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_queueNameUI = new JTextField();
        this.m_queueNameUI.setEditable(false);
        this.m_queueNameUI.setBorder(null);
        this.m_queuePanel.add((Component)this.m_queueNameUI, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupViewByPanel() {
        if (this.m_bLayoutInitialized) {
            return;
        }
        try {
            this.setUpdating();
            try {
                JPanel btnPanel = new JPanel();
                GridBagConstraints c = new GridBagConstraints();
                btnPanel.setLayout(new GridBagLayout());
                this.m_viewByPanel = new JPanel(new BorderLayout());
                Border border = BorderFactory.createEtchedBorder();
                this.m_viewByPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VWResource.s_label.toString(VWResource.s_viewBy)));
                ButtonGroup grp = new ButtonGroup();
                c.gridx = 0;
                c.gridy = 0;
                c.gridwidth = 3;
                c.gridheight = 1;
                c.fill = 2;
                c.anchor = 21;
                this.m_stepRadio = new JRadioButton(VWResource.s_step);
                this.m_stepRadio.setPreferredSize(new Dimension(30, 20));
                this.m_stepRadio.setSelected(true);
                grp.add(this.m_stepRadio);
                btnPanel.add((Component)this.m_stepRadio, c);
                c.gridy = 1;
                c.gridwidth = 1;
                this.m_participantRadio = new JRadioButton(VWResource.s_participant);
                Dimension dim = this.m_participantRadio.getPreferredSize();
                dim.height = 20;
                this.m_participantRadio.setPreferredSize(dim);
                grp.add(this.m_participantRadio);
                btnPanel.add((Component)this.m_participantRadio, c);
                c.gridx = 1;
                c.gridwidth = 2;
                c.fill = 2;
                c.weightx = 1.0;
                this.m_participantCombo = new JComboBox();
                this.m_stepAndParticipantRenderer = new VWStepNParticipantRenderer();
                this.m_participantCombo.setRenderer(this.m_stepAndParticipantRenderer);
                this.m_participantCombo.setPreferredSize(new Dimension(40, 20));
                btnPanel.add((Component)this.m_participantCombo, c);
                this.setupTabbedPane();
                this.m_viewByPanel.add((Component)btnPanel, "First");
                this.m_viewByPanel.add((Component)this.m_stepTabbedPane, "Center");
                this.m_stepTabbedPane.setSelectedIndex(0);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        finally {
            this.doneUpdating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupTabbedPane() {
        if (this.m_bLayoutInitialized) {
            return;
        }
        try {
            this.setUpdating();
            super.setupTabbedPane();
            if (this.m_stepTabbedPane != null) {
                this.m_stepTabbedPane = new JTabbedPane();
                this.m_stepTabbedPane.addTab(VWResource.s_general, null, this.m_generalPanel, null);
                this.m_stepTabbedPane.addTab(VWResource.s_fields, null, this.m_fieldsPanel, null);
                this.m_stepTabbedPane.addTab(VWResource.s_attachments, null, this.m_attachmentsPanel, null);
                this.m_stepTabbedPane.addTab(VWResource.s_workflowGroup, null, this.m_wfGroupsPanel, null);
                this.m_stepTabbedPane.addTab(VWResource.s_parameters, null, this.m_parameterPanel, null);
                this.m_stepTabbedPane.addTab(VWResource.s_assignments, null, this.m_assignmentsPanel, null);
                this.m_stepTabbedPane.addTab(VWResource.s_routing, null, this.m_routingPanel, null);
                if (this.m_rulesPanel != null) {
                    this.m_stepTabbedPane.addTab(VWResource.s_rules, null, this.m_rulesPanel, null);
                }
            }
        }
        finally {
            this.doneUpdating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initViewByPanel() {
        try {
            this.setUpdating();
            this.m_participantsModel = new DefaultComboBoxModel();
            this.initParticipants();
            this.m_participantCombo.setModel(this.m_participantsModel);
            if (this.m_participants != null && this.m_participants.size() > 0) {
                this.m_participantCombo.setSelectedIndex(0);
            }
            this.m_stepTabbedPane.addChangeListener(this);
            this.m_stepRadioItemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (VWQueueUserStepPropPanel.this.isUpdating() || !VWQueueUserStepPropPanel.this.isRuntimeStep() || !VWQueueUserStepPropPanel.this.m_stepRadio.isEnabled()) {
                        return;
                    }
                    if (e.getStateChange() == 1 && !VWQueueUserStepPropPanel.this.m_bStepView) {
                        VWQueueUserStepPropPanel.this.m_bStepView = true;
                        VWQueueUserStepPropPanel.this.setSelectionChanged(2);
                        VWQueueUserStepPropPanel.this.init();
                    }
                }
            };
            this.m_stepRadio.addItemListener(this.m_stepRadioItemListener);
            this.m_participantComboItemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (VWQueueUserStepPropPanel.this.isUpdating() || !VWQueueUserStepPropPanel.this.isRuntimeStep() || !VWQueueUserStepPropPanel.this.m_participantCombo.isEnabled()) {
                        return;
                    }
                    VWQueueUserStepPropPanel.this.m_selectedParticipant = (VWTrkParticipant)VWQueueUserStepPropPanel.this.m_participantCombo.getSelectedItem();
                    if (VWQueueUserStepPropPanel.this.m_bStepView) {
                        VWQueueUserStepPropPanel.this.m_participantRadio.setSelected(true);
                    } else {
                        VWQueueUserStepPropPanel.this.setSelectionChanged(1);
                        VWQueueUserStepPropPanel.this.init();
                    }
                }
            };
            this.m_participantCombo.addItemListener(this.m_participantComboItemListener);
            this.m_participantRadioItemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (VWQueueUserStepPropPanel.this.isUpdating() || !VWQueueUserStepPropPanel.this.isRuntimeStep() || !VWQueueUserStepPropPanel.this.m_participantRadio.isEnabled()) {
                        return;
                    }
                    if (e.getStateChange() == 1 && VWQueueUserStepPropPanel.this.m_bStepView) {
                        VWQueueUserStepPropPanel.this.m_selectedParticipant = (VWTrkParticipant)VWQueueUserStepPropPanel.this.m_participantCombo.getSelectedItem();
                        VWQueueUserStepPropPanel.this.m_bStepView = false;
                        VWQueueUserStepPropPanel.this.setSelectionChanged(2);
                        VWQueueUserStepPropPanel.this.init();
                    }
                }
            };
            this.m_participantRadio.addItemListener(this.m_participantRadioItemListener);
        }
        finally {
            this.doneUpdating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initParticipants() {
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        try {
            this.setUpdating();
            if (this.getSelectedStep() == null) {
                this.m_participantsModel.removeAllElements();
                return;
            }
            this.m_participants = null;
            VWTrkStepOccurrence occurrence = this.getSelectedOccurrence();
            if (occurrence != null) {
                this.m_participants = occurrence.getFinalParticipants();
            } else {
                VWParticipant[] participants;
                VWStepDefinition stepDefinition = this.getSelectedStep().getStepDefinition();
                if (stepDefinition != null && (participants = stepDefinition.getParticipants()) != null) {
                    this.m_participants = new Vector();
                    for (int i = 0; i < participants.length; ++i) {
                        VWParticipant participant = participants[i];
                        int loc = this.m_participants.size();
                        String participantName = participant.getParticipantName();
                        if (participantName == null) {
                            loc = 0;
                        } else {
                            for (int j = 0; j < this.m_participants.size(); ++j) {
                                String name = null;
                                Object obj = this.m_participants.elementAt(j);
                                if (obj == null) continue;
                                if (obj instanceof VWTrkParticipant) {
                                    name = ((VWTrkParticipant)obj).getParticipant().getParticipantName();
                                } else if (obj instanceof VWParticipant) {
                                    name = ((VWParticipant)obj).getParticipantName();
                                } else {
                                    if (!(obj instanceof String)) continue;
                                    name = (String)obj;
                                }
                                if (name == null || VWStringUtils.compareIgnoreCase(participantName, name) >= 0) continue;
                                loc = j;
                                break;
                            }
                        }
                        if (loc >= this.m_participants.size()) {
                            this.m_participants.addElement(participant);
                            continue;
                        }
                        this.m_participants.insertElementAt(participant, loc);
                    }
                }
            }
            if (this.m_participantCombo != null) {
                this.m_participantCombo.setEnabled(false);
            }
            this.m_participantsModel.removeAllElements();
            if (this.m_participants == null) {
                this.m_participants = new Vector();
                this.m_selectedParticipant = null;
            } else {
                for (int index = 0; index < this.m_participants.size(); ++index) {
                    String participantName = VWStepNParticipantRenderer.toString(this.m_participants.elementAt(index));
                    String name = null;
                    boolean bInserted = false;
                    for (int j = 0; j < this.m_participantsModel.getSize(); ++j) {
                        name = VWStepNParticipantRenderer.toString(this.m_participantsModel.getElementAt(j));
                        if (VWStringUtils.compareIgnoreCase(participantName, name) >= 0) continue;
                        this.m_participantsModel.insertElementAt(this.m_participants.elementAt(index), j);
                        bInserted = true;
                        break;
                    }
                    if (bInserted) continue;
                    this.m_participantsModel.addElement(this.m_participants.elementAt(index));
                }
                if (this.isRuntimeStep()) {
                    if (this.m_selectedParticipant == null || !this.m_participants.contains(this.m_selectedParticipant)) {
                        this.m_selectedParticipant = (VWTrkParticipant)this.m_participants.elementAt(0);
                    }
                    if (this.m_participantCombo != null) {
                        this.m_participantCombo.setSelectedItem(this.m_selectedParticipant);
                    }
                }
            }
            if (this.m_participantCombo != null) {
                this.m_participantCombo.setEnabled(true);
            }
        }
        finally {
            this.doneUpdating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initData() {
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        try {
            this.setUpdating();
            if (this.isDataUpdated()) {
                return;
            }
            switch (this.getSelectionChanged()) {
                case 4: 
                case 5: {
                    if (this.getSelectedStep() != null) {
                        this.m_stepDefinition = this.getSelectedStep().getStepDefinition();
                        this.m_instructions = this.m_stepDefinition.getDescription();
                        if (this.m_instructions == null) {
                            this.m_instructions = "";
                        }
                    }
                }
                case 3: {
                    this.initParticipants();
                }
            }
            this.updateTabs();
            this.setDataUpdated(true);
        }
        finally {
            this.doneUpdating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupLayout() {
        if (this.m_bLayoutInitialized) {
            return;
        }
        try {
            this.setUpdating();
            this.setLayout(new BorderLayout());
            this.setupTopPanel();
            this.add((Component)this.m_topPanel, "First");
            this.setupViewByPanel();
            this.add((Component)this.m_viewByPanel, "Center");
            this.m_bLayoutInitialized = true;
        }
        finally {
            this.doneUpdating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDisplay() {
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        if (this.isDisplayUpdated()) {
            return;
        }
        try {
            this.setUpdating();
            switch (this.getSelectionChanged()) {
                case 4: 
                case 5: {
                    this.m_instructionsUI.setText(this.m_instructions);
                    this.m_participantRadio.setEnabled(this.isRuntimeStep());
                    this.m_participantCombo.setEnabled(this.m_participants != null && this.m_participants.size() > 0);
                    this.m_stepRadio.setEnabled(this.isRuntimeStep());
                }
                case 3: {
                    this.m_participantsModel.removeAllElements();
                    if (this.getSelectedStep() != null) {
                        for (int index = 0; index < this.m_participants.size(); ++index) {
                            this.m_participantsModel.addElement(this.m_participants.elementAt(index));
                        }
                    }
                    this.m_stepRadio.setSelected(this.m_bStepView && this.isRuntimeStep());
                    this.m_participantRadio.setSelected(!this.m_bStepView && this.isRuntimeStep());
                }
            }
            this.updateSelectedTabNow();
        }
        finally {
            this.doneUpdating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDataWithSelectedStep() {
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        try {
            this.setUpdating();
            VWTrkStep step = this.getSelectedStep();
            if (step != null) {
                this.clearAllData();
                this.clearAllControls();
                if (step != null) {
                    String queueName = step.getQueueName();
                    if (queueName != null) {
                        this.m_queueNameUI.setText(queueName);
                    } else {
                        this.m_queueNameUI.setText("");
                    }
                }
            }
        }
        finally {
            this.doneUpdating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAllData() {
        try {
            this.setUpdating();
            super.clearAllData();
            this.m_participants = null;
            this.m_selectedParticipant = null;
        }
        finally {
            this.doneUpdating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAllControls() {
        try {
            this.setUpdating();
            this.m_participantsModel.removeAllElements();
            this.m_queueNameUI.setText("");
        }
        finally {
            this.doneUpdating();
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        Object obj = event.getSource();
        if (obj == null) {
            return;
        }
        if (obj instanceof IVWPropertyChangeSource) {
            IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
            int type = event.getID();
            block0 : switch (type) {
                case 704: {
                    Vector items = source.getItemsChanged();
                    if (items == null) {
                        return;
                    }
                    int stepId = -1;
                    if (this.getSelectedStep() == null) break;
                    int thisStepId = this.getSelectedStep().getStepId();
                    for (int i = 0; i < items.size(); ++i) {
                        obj = items.elementAt(i);
                        if (obj == null) continue;
                        if (obj instanceof VWTrkStep) {
                            stepId = ((VWTrkStep)obj).getStepId();
                        } else if (obj instanceof VWTrkStepOccurrence) {
                            stepId = ((VWTrkStepOccurrence)obj).getStepId();
                        }
                        if (stepId != thisStepId) continue;
                        this.initParticipants();
                        this.refreshTabs();
                        break block0;
                    }
                    break;
                }
                case 705: {
                    this.initParticipants();
                    this.refreshTabs();
                }
            }
        }
    }

    public void removeReferences() {
        super.removeReferences();
        if (this.m_participants != null) {
            this.m_participants.removeAllElements();
            this.m_participants = null;
        }
        this.m_topPanel = null;
        if (this.m_queuePanel != null) {
            this.m_queuePanel.removeAll();
            this.m_queuePanel = null;
        }
        if (this.m_stepTabbedPane != null) {
            this.m_stepTabbedPane.removeChangeListener(this);
            this.m_stepTabbedPane.removeAll();
        }
        if (this.m_stepRadio != null) {
            this.m_stepRadio.removeItemListener(this.m_stepRadioItemListener);
            this.m_stepRadio = null;
        }
        this.m_stepRadioItemListener = null;
        if (this.m_participantRadio != null) {
            this.m_participantRadio.removeItemListener(this.m_participantRadioItemListener);
            this.m_participantRadio = null;
        }
        this.m_participantRadioItemListener = null;
        if (this.m_participantCombo != null) {
            this.m_participantCombo.removeItemListener(this.m_participantComboItemListener);
            this.m_participantCombo.setRenderer(null);
            this.m_participantCombo = null;
        }
        this.m_participantComboItemListener = null;
        if (this.m_generalPanel != null) {
            this.m_generalPanel.removeReferences();
            this.m_generalPanel = null;
        }
        if (this.m_fieldsPanel != null) {
            this.m_fieldsPanel.removeReferences();
            this.m_fieldsPanel = null;
        }
        if (this.m_attachmentsPanel != null) {
            this.m_attachmentsPanel.removeReferences();
            this.m_attachmentsPanel = null;
        }
        if (this.m_assignmentsPanel != null) {
            this.m_assignmentsPanel.removeReferences();
            this.m_assignmentsPanel = null;
        }
        if (this.m_parameterPanel != null) {
            this.m_parameterPanel.removeReferences();
            this.m_parameterPanel = null;
        }
        if (this.m_wfGroupsPanel != null) {
            this.m_wfGroupsPanel.removeReferences();
            this.m_wfGroupsPanel = null;
        }
        if (this.m_routingPanel != null) {
            this.m_routingPanel.removeReferences();
            this.m_routingPanel = null;
        }
        this.m_queueNameLabel = null;
        this.m_queueNameUI = null;
        if (this.m_viewByPanel != null) {
            this.m_viewByPanel.removeAll();
            this.m_viewByPanel = null;
        }
        this.m_stepAndParticipantRenderer = null;
        if (this.m_participantsModel != null) {
            this.m_participantsModel.removeAllElements();
            this.m_participantsModel = null;
        }
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
        this.removeAll();
    }

    protected void updatePanelsComponentOrientation(JPanel canvasPanel) {
        try {
            if (canvasPanel != null) {
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                canvasPanel.applyComponentOrientation(compOrientation);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

